/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class MultiblockProcess<R extends MultiblockRecipe> {
    private final ResourceLocation recipeId;
    private final BiFunction<Level, ResourceLocation, R> getRecipe;
    public int processTick;
    private LevelDependentData<R> levelData;
    public boolean clearProcess = false;

    public MultiblockProcess(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe) {
        this.recipeId = recipeId;
        this.getRecipe = getRecipe;
        this.processTick = 0;
    }

    public MultiblockProcess(R recipe, BiFunction<Level, ResourceLocation, R> getRecipe) {
        this.recipeId = ((IESerializableRecipe)recipe).m_6423_();
        this.getRecipe = getRecipe;
        this.processTick = 0;
        this.populateLevelData(recipe);
    }

    protected List<ItemStack> getRecipeItemOutputs(PoweredMultiblockBlockEntity<?, R> multiblock) {
        Object recipe = this.getLevelData((Level)multiblock.m_58904_()).recipe;
        if (recipe == null) {
            return List.of();
        }
        return recipe.getActualItemOutputs(multiblock);
    }

    protected List<FluidStack> getRecipeFluidOutputs(PoweredMultiblockBlockEntity<?, R> multiblock) {
        Object recipe = this.getLevelData((Level)multiblock.m_58904_()).recipe;
        if (recipe == null) {
            return List.of();
        }
        return recipe.getActualFluidOutputs(multiblock);
    }

    public boolean canProcess(PoweredMultiblockBlockEntity<?, R> multiblock) {
        LevelDependentData<R> levelData = this.getLevelData(multiblock.m_58904_());
        if (levelData.recipe == null) {
            return true;
        }
        if (multiblock.energyStorage.extractEnergy(levelData.energyPerTick, true) == levelData.energyPerTick) {
            List<FluidStack> fluidOutputs;
            List<ItemStack> outputs = this.getRecipeItemOutputs(multiblock);
            if (outputs != null && !outputs.isEmpty()) {
                int[] outputSlots = multiblock.getOutputSlots();
                for (ItemStack output : outputs) {
                    if (output.m_41619_()) continue;
                    boolean canOutput = false;
                    if (outputSlots == null) {
                        canOutput = true;
                    } else {
                        for (int iOutputSlot : outputSlots) {
                            ItemStack s = (ItemStack)multiblock.getInventory().get(iOutputSlot);
                            if (!s.m_41619_() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.m_41613_() + output.m_41613_() > multiblock.getSlotLimit(iOutputSlot))) continue;
                            canOutput = true;
                            break;
                        }
                    }
                    if (canOutput) continue;
                    return false;
                }
            }
            if ((fluidOutputs = ((MultiblockRecipe)levelData.recipe).getFluidOutputs()) != null && !fluidOutputs.isEmpty()) {
                IFluidTank[] tanks = multiblock.getInternalTanks();
                int[] outputTanks = multiblock.getOutputTanks();
                for (FluidStack output : fluidOutputs) {
                    if (output == null || output.getAmount() <= 0) continue;
                    boolean canOutput = false;
                    if (tanks == null || outputTanks == null) {
                        canOutput = true;
                    } else {
                        for (int iOutputTank : outputTanks) {
                            if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                            canOutput = true;
                            break;
                        }
                    }
                    if (canOutput) continue;
                    return false;
                }
            }
            return multiblock.additionalCanProcessCheck(this);
        }
        return false;
    }

    public void doProcessTick(PoweredMultiblockBlockEntity<?, R> multiblock) {
        LevelDependentData<R> levelData = this.getLevelData(multiblock.m_58904_());
        if (levelData.recipe == null) {
            this.clearProcess = true;
            return;
        }
        int energyExtracted = levelData.energyPerTick;
        int ticksAdded = 1;
        if (levelData.recipe.getMultipleProcessTicks() > 1) {
            int possibleTicks;
            int averageInsertion = multiblock.energyStorage.getAverageInsertion();
            if ((averageInsertion = multiblock.energyStorage.extractEnergy(averageInsertion, true)) > energyExtracted && (possibleTicks = Math.min(averageInsertion / levelData.energyPerTick, Math.min(levelData.recipe.getMultipleProcessTicks(), levelData.maxTicks - this.processTick))) > 1) {
                ticksAdded = possibleTicks;
                energyExtracted *= ticksAdded;
            }
        }
        multiblock.energyStorage.extractEnergy(energyExtracted, false);
        this.processTick += ticksAdded;
        if (this.processTick >= levelData.maxTicks) {
            this.processFinish(multiblock);
        }
    }

    protected void processFinish(PoweredMultiblockBlockEntity<?, R> multiblock) {
        List<FluidStack> fluidOutputs;
        List<ItemStack> outputs = this.getRecipeItemOutputs(multiblock);
        if (outputs != null && !outputs.isEmpty()) {
            int[] outputSlots = multiblock.getOutputSlots();
            block0: for (ItemStack output : outputs) {
                if (output.m_41619_()) continue;
                if (outputSlots == null || multiblock.getInventory() == null) {
                    multiblock.doProcessOutput(output.m_41777_());
                    continue;
                }
                for (Object iOutputSlot : (Object)outputSlots) {
                    ItemStack s = (ItemStack)multiblock.getInventory().get((int)iOutputSlot);
                    if (s.m_41619_()) {
                        multiblock.getInventory().set((int)iOutputSlot, (Object)output.m_41777_());
                        continue block0;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.m_41613_() + output.m_41613_() > multiblock.getSlotLimit((int)iOutputSlot)) continue;
                    ((ItemStack)multiblock.getInventory().get((int)iOutputSlot)).m_41769_(output.m_41613_());
                    continue block0;
                }
            }
        }
        if ((fluidOutputs = this.getRecipeFluidOutputs(multiblock)) != null && !fluidOutputs.isEmpty()) {
            IFluidTank[] tanks = multiblock.getInternalTanks();
            int[] outputTanks = multiblock.getOutputTanks();
            block2: for (FluidStack output : fluidOutputs) {
                if (output == null || output.getAmount() <= 0) continue;
                if (tanks == null || outputTanks == null) {
                    multiblock.doProcessFluidOutput(output);
                    continue;
                }
                for (int iOutputTank : outputTanks) {
                    if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                    tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.EXECUTE);
                    continue block2;
                }
            }
        }
        multiblock.onProcessFinish(this);
        this.clearProcess = true;
    }

    public abstract void writeExtraDataToNBT(CompoundTag var1);

    protected LevelDependentData<R> getLevelData(Level level) {
        if (this.levelData == null) {
            this.populateLevelData((MultiblockRecipe)this.getRecipe.apply(level, this.recipeId));
        }
        return this.levelData;
    }

    private void populateLevelData(R recipe) {
        if (recipe != null) {
            int maxTicks = ((MultiblockRecipe)recipe).getTotalProcessTime();
            int energyPerTick = ((MultiblockRecipe)recipe).getTotalProcessEnergy() / maxTicks;
            this.levelData = new LevelDependentData<R>(recipe, maxTicks, energyPerTick);
        } else {
            this.levelData = new LevelDependentData<Object>(null, 20, 0);
        }
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public int getMaxTicks(Level level) {
        return this.getLevelData((Level)level).maxTicks;
    }

    @Nullable
    public R getRecipe(Level level) {
        return this.getLevelData((Level)level).recipe;
    }

    protected record LevelDependentData<R extends MultiblockRecipe>(@Nullable R recipe, int maxTicks, int energyPerTick) {
    }
}

